/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8239;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8239.STDecoder;
import ibm.nways.jdm8239.StackData;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class StackInfo {
    private static final int RASID = 19;
    private static final int RASSUBID = 19;
    static ResourceBundle stackBundle;
    public static final String PROPNAME = "StackInfo.jdm8239.nways.ibm";
    public static final int RNOT_INSTALLED = 0;
    public static final int FIBER_RIRO = 1;
    public static final int COPPER_RIRO = 2;
    public static final int WRAPPED = 1;
    public static final int UNWRAPPED = 0;
    public static final int MAXSTACK = 8;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int Timeouts = 3;
    public static final int ServerProblems = 4;
    public static final int WrongBox = 5;
    public static final OID Model_SysOID;
    private GenModel deviceModel;
    private Hashtable modelList;
    private JdmBrowser deviceBrowser;
    private Hashtable moduleGraphicList;
    private Hashtable stackUnits;
    private STDecoder[] decoders;
    private int deviceStatus;
    private boolean isApplication;
    private GraphicPanel deviceGraphic;
    private Thread portThread;
    private int stackSize;
    private static String bundleName;
    public static final String path = "/ibm/nways/jdm8239";
    protected static final String PropertiesFile = "properties/Jdm8239.txt";
    boolean loggingOn;
    boolean disposeCalled;
    Integer[] hubOrderArray;

    public StackInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        block14: {
            this.moduleGraphicList = new Hashtable();
            this.stackUnits = new Hashtable();
            this.decoders = new STDecoder[8];
            this.loggingOn = false;
            this.disposeCalled = false;
            if (RAS.isEnabled(19, 19)) {
                RAS.enter(19, 19, this, "StackInfo");
            }
            ModelInfo modelInfo = null;
            Serializable serializable = null;
            this.deviceBrowser = jdmBrowser;
            this.isApplication = this.deviceBrowser.getIsApplication();
            if (this.isApplication) {
                this.loggingOn = Log.getLog().getLoggingState();
            }
            stackBundle = ResourceBundle.getBundle("ibm.nways.jdm8239.Resources");
            if (genModel == null) {
                this.deviceStatus = 4;
                if (RAS.isEnabled(19, 19)) {
                    RAS.trace(19, 19, this, "StackInfo", "null device model - abort processing");
                }
            } else {
                this.deviceModel = genModel;
                this.modelList = new Hashtable();
                try {
                    modelInfo = this.deviceModel.getInfo("InitialConfig");
                    serializable = modelInfo.get("InitialConfig.SysObjectID");
                    if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                        this.deviceStatus = 2;
                        if (RAS.isEnabled(19, 19)) {
                            RAS.trace(19, 19, this, "StackInfo", "device not responding" + serializable.toString());
                        }
                        new BoxDownMsg(this.deviceBrowser.getFrame(), stackBundle.getString("RootFolderTitle"));
                    } else {
                        OID oID = new OID(serializable.toString());
                        if (!oID.equals(Model_SysOID)) {
                            if (RAS.isEnabled(19, 19)) {
                                RAS.trace(19, 19, this, "StackInfo", "Wrong device. SysOID = " + oID);
                            }
                            this.deviceStatus = 5;
                            new WrongSysOidMsg(this.deviceBrowser.getFrame(), stackBundle.getString("deviceName"));
                        } else {
                            this.deviceStatus = 1;
                        }
                    }
                }
                catch (Exception exception) {
                    this.deviceStatus = 4;
                    if (!RAS.isEnabled(19, 19)) break block14;
                    RAS.logException(19, 19, this, "StackInfo", exception);
                }
            }
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "StackInfo");
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, StackInfo stackInfo) {
        navigationContext.put((Object)PROPNAME, (Object)stackInfo);
    }

    public static StackInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (StackInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public Hashtable getStackUnits() {
        return this.stackUnits;
    }

    public STDecoder[] getStackHubs() {
        return this.decoders;
    }

    public String getBundleName() {
        return bundleName;
    }

    public String getPath() {
        return path;
    }

    public JdmBrowser getJdm8239Browser() {
        return this.deviceBrowser;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public int getModuleType(int n) {
        if (this.decoders != null && this.decoders[n] != null) {
            return this.decoders[n].module(STDecoder.HUBTYPE);
        }
        return 0;
    }

    public Hashtable getModuleGraphicList() {
        return this.moduleGraphicList;
    }

    private int[] getHubsInSegment(int n, int n2, int[] nArray, Integer[] integerArray) {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, this, "getHubsInSegment");
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        if (n2 == 0) {
            n3 = n - 1;
            while (n3 >= 0) {
                if (nArray[n3] != 0) break;
                --n3;
            }
            ++n3;
            while (n3 < n) {
                vector.addElement(new Integer(n3++));
            }
        }
        if (vector.size() != n) {
            n3 = 0;
            while (n3 < n) {
                if (nArray[n3] == n2) break;
                ++n3;
            }
            while (n3 < n) {
                if (nArray[n3] != n2) break;
                vector.addElement(new Integer(n3++));
            }
        }
        int[] nArray2 = new int[vector.size()];
        n3 = 0;
        while (n3 < vector.size()) {
            nArray2[n3] = integerArray[(Integer)vector.elementAt(n3)];
            ++n3;
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "getHubsInSegment");
        }
        return nArray2;
    }

    void rotateHubOrderArray() {
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, this, "rotateHubOrderArray");
        }
        int n = this.stackSize + 1;
        Integer[] integerArray = new Integer[this.stackSize];
        int n2 = 0;
        int n3 = 0;
        n3 = 0;
        while (n3 < this.stackSize) {
            if (this.hubOrderArray[n3] < n && this.hubOrderArray[n3] > 0) {
                n = this.hubOrderArray[n3];
                n2 = n3;
            }
            integerArray[n3] = this.hubOrderArray[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.stackSize) {
            this.hubOrderArray[n3] = integerArray[(n3 + n2) % this.stackSize];
            ++n3;
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "rotateHubOrderArray");
        }
    }

    public GraphicPanel getDeviceGraphic() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Properties properties;
        Serializable serializable;
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, this, "getDeviceGraphic");
        }
        GenModel genModel = null;
        GenModel genModel2 = null;
        int n2 = 0;
        int n3 = 30;
        int n4 = n2;
        int n5 = 97 + n2;
        if (this.deviceGraphic != null) {
            if (RAS.isEnabled(19, 19)) {
                RAS.exit(19, 19, this, "getDeviceGraphic");
            }
            return this.deviceGraphic;
        }
        try {
            serializable = new URL(this.deviceBrowser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 19)) {
                RAS.logException(19, 19, this, "Jdm8239:StackInfo: Error getting properties: ", exception);
            }
            properties = null;
        }
        JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get("layout.scheme"));
            n = (Integer)serializable;
            jdmLayout.setScheme(n);
            object4 = (String)((Hashtable)properties).get("layout.fractions");
            object3 = new StringTokenizer((String)object4);
            object2 = new float[((StringTokenizer)object3).countTokens()];
            boolean bl = true;
            int n6 = 0;
            while (n6 < ((float[])object2).length && ((StringTokenizer)object3).hasMoreTokens()) {
                object = ((StringTokenizer)object3).nextToken();
                try {
                    object2[n6] = Float.valueOf((String)object).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    if (RAS.isEnabled(19, 19)) {
                        RAS.logException(19, 19, this, "Jdm8239:StackInfo: Bad layout.fractions parm", (Exception)numberFormatException);
                    }
                    bl = false;
                }
                ++n6;
            }
            if (bl) {
                jdmLayout.setFracts((float[])object2);
            }
        } else {
            n = 0;
            jdmLayout.setScheme(n);
        }
        GraphicContainer graphicContainer = new GraphicContainer();
        serializable = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)serializable);
        if (this.deviceStatus == 1) {
            try {
                genModel = (GenModel)this.deviceModel.getComponent("System");
                object4 = (GenModel)this.deviceModel.getComponent("StackHubOrder");
                if (genModel != null) {
                    genModel2 = (GenModel)this.deviceModel.getComponent("StackSummary");
                    if (genModel2 != null) {
                        object3 = genModel2.getRestOfInfo("Panel", "default", null, null);
                        this.stackSize = ((Vector)object3).size();
                        if (object3 != null && this.stackSize > 0) {
                            int n7;
                            int n8;
                            int n9;
                            Object object5;
                            object2 = ((Vector)object3).elements();
                            while (object2.hasMoreElements()) {
                                ModelInfo modelInfo = (ModelInfo)object2.nextElement();
                                Integer n10 = (Integer)modelInfo.get("Index.StackSummaryHubId");
                                this.decoders[n10.intValue() - 1] = new STDecoder();
                                object = modelInfo.get("Panel.StackSummaryInfo");
                                this.decoders[n10 - 1].setEntry((OctetString)object);
                            }
                            ModelInfo modelInfo = object4.getInfo("Panel", "default", null);
                            String string = (String)((Object)modelInfo.get("Panel.StackMgtHubOrder"));
                            object = new StringTokenizer(string, ", ");
                            this.hubOrderArray = new Integer[this.stackSize];
                            int n11 = 0;
                            while (n11 < this.stackSize) {
                                this.hubOrderArray[n11] = new Integer(0);
                                ++n11;
                            }
                            int n12 = 0;
                            while (((StringTokenizer)object).hasMoreElements() && n12 < this.stackSize) {
                                object5 = new Integer((String)((StringTokenizer)object).nextElement());
                                this.hubOrderArray[n12++] = object5;
                            }
                            this.rotateHubOrderArray();
                            object5 = new int[this.stackSize];
                            int[] nArray = new int[this.stackSize];
                            int[] nArray2 = new int[this.stackSize];
                            n12 = 0;
                            while (n12 < this.stackSize) {
                                n9 = this.hubOrderArray[n12] - 1;
                                n8 = this.decoders[n9].module(STDecoder.HUBID);
                                if (n8 != -1) {
                                    n7 = this.decoders[n9].version();
                                    object5[n12] = this.decoders[n9].module(STDecoder.DATAINSTATUS);
                                    nArray[n12] = this.decoders[n9].module(STDecoder.DATAOUTSTATUS);
                                    if (n7 == STDecoder.V1) {
                                        object5[n12] = object5[n12] == 1 ? 0 : 1;
                                        nArray[n12] = nArray[n12] == 1 ? 0 : 1;
                                    }
                                }
                                ++n12;
                            }
                            n9 = 0;
                            nArray2[0] = n8 = 0;
                            while (n9 < this.stackSize - 1) {
                                if (nArray[n9] != 0 || object5[n9 + 1] != 0) {
                                    // empty if block
                                }
                                nArray2[++n9] = ++n8;
                            }
                            if (nArray[n9] == 1 || object5[0] == 1) {
                                ++n8;
                            } else if (n8 > 0) {
                                while (nArray2[n9] == n8) {
                                    nArray2[n9] = 0;
                                    --n9;
                                }
                            }
                            n7 = n8 > 1 ? n8 : 1;
                            n11 = 0;
                            while (n11 < n7) {
                                int[] nArray3 = this.getHubsInSegment(this.stackSize, n11, nArray2, this.hubOrderArray);
                                this.createSegmentDisplay(graphicContainer, nArray3.length, n4);
                                int n13 = 0;
                                while (n13 < nArray3.length) {
                                    StackData stackData = this.createHubDisplay(genModel, this.decoders[nArray3[n13] - 1], graphicContainer, n3, n2);
                                    this.stackUnits.put(stackData.hubIndex, stackData);
                                    n3 += n5;
                                    n2 += n5;
                                    n4 += n5;
                                    ++n13;
                                }
                                ++n11;
                            }
                        } else {
                            this.deviceStatus = 0;
                        }
                    } else {
                        this.deviceStatus = 0;
                    }
                } else {
                    this.deviceStatus = 0;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 19)) {
                    RAS.logException(19, 19, this, "Jdm8239:StackInfo: Problem getting graphic initialized", exception);
                }
                object3 = new Label(stackBundle.getString("unknown"), 1);
                ((Component)object3).setLocation(new Point(35, -5));
                graphicContainer.add((Component)object3);
            }
        }
        if (this.deviceStatus != 1) {
            if (RAS.isEnabled(19, 19)) {
                RAS.trace(19, 19, this, "getGraphicDevice", "problem getting device information");
            }
            object4 = "unknown";
            switch (this.deviceStatus) {
                case 0: {
                    object4 = "unknown";
                    break;
                }
                case 2: {
                    object4 = "Not Connected";
                    break;
                }
                case 5: {
                    object4 = "Not Configured";
                    break;
                }
                case 4: {
                    object4 = "Not Connected";
                    break;
                }
                default: {
                    object4 = "unknown";
                }
            }
            object3 = new Label(stackBundle.getString((String)object4), 1);
            ((Component)object3).setLocation(new Point(35, -5));
            graphicContainer.add((Component)object3);
        }
        this.deviceGraphic = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)graphicContainer);
        if (this.decoders != null && this.decoders.length != 0 && (this.portThread == null || this.portThread != null && !this.portThread.isAlive())) {
            this.portThread = new PortThread();
            this.portThread.start();
        }
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "getDeviceGraphic");
        }
        return this.deviceGraphic;
    }

    private void createSegmentDisplay(GraphicContainer graphicContainer, int n, int n2) {
        String string = "/ibm/nways/jdm8239/SEG_" + n + ".gif";
        CookieTray cookieTray = new CookieTray(bundleName, new Point(730, n2), string, "SEGMENT", this.deviceBrowser, null, null);
        graphicContainer.add((GraphicContainer)cookieTray);
    }

    private StackData createHubDisplay(GenModel genModel, STDecoder sTDecoder, GraphicContainer graphicContainer, int n, int n2) {
        Object object;
        String string;
        if (RAS.isEnabled(19, 19)) {
            RAS.enter(19, 19, this, "createHubDisplay");
        }
        String string2 = "ibm.nways.mib2.eui.SystemPanel";
        String string3 = "MODEL00";
        StackData stackData = new StackData();
        int n3 = sTDecoder.module(STDecoder.HUBID);
        int n4 = sTDecoder.module(STDecoder.HUBTYPE);
        sTDecoder.numberOfPorts();
        stackData.hubIndex = new Integer(n3);
        switch (n4) {
            case 1: {
                string3 = String.valueOf(string3) + "1";
                break;
            }
            case 0: {
                string3 = String.valueOf(string3) + "2";
                break;
            }
            default: {
                string3 = String.valueOf(string3) + "0";
            }
        }
        String string4 = string3;
        string3 = "/ibm/nways/jdm8239/" + string3 + ".gif";
        Label label = new Label(String.valueOf(stackBundle.getString("ID")) + new Integer(n3).toString(), 1);
        label.setLocation(new Point(-18, n));
        graphicContainer.add(label);
        CookieTray cookieTray = new CookieTray(bundleName, new Point(30, n2), string3, String.valueOf(string4) + "_" + n3, this.deviceBrowser, genModel, string2);
        graphicContainer.add((GraphicContainer)cookieTray);
        if (sTDecoder.numberOfPorts() > 16) {
            String string5 = "PORT_EXP";
            string = "/ibm/nways/jdm8239/" + string5 + ".gif";
            object = new CookieTray(bundleName, new Point(185, 49), string, string5, this.deviceBrowser, genModel, string2);
            cookieTray.add((GraphicContainer)object);
            stackData.portExtTray = object;
        }
        stackData.hubPorts = new Integer(sTDecoder.numberOfPorts());
        int n5 = sTDecoder.module(STDecoder.RIROTYPE);
        if (n5 == 1 || n5 == 2) {
            string = null;
            switch (n5) {
                case 1: {
                    string = "FIB_RIRO";
                    break;
                }
                case 2: {
                    string = "CU_RIRO";
                    break;
                }
            }
            object = "/ibm/nways/jdm8239/" + string + ".gif";
            CookieTray cookieTray2 = new CookieTray(bundleName, new Point(4, 49), (String)object, string, this.deviceBrowser, genModel, string2);
            cookieTray.add((GraphicContainer)cookieTray2);
            stackData.riroTray = cookieTray2;
            stackData.riroType = new Integer(n5);
        }
        stackData.hubTray = cookieTray;
        if (RAS.isEnabled(19, 19)) {
            RAS.exit(19, 19, this, "createHubDisplay");
        }
        return stackData;
    }

    public void dispose() {
        this.disposeCalled = true;
        if (this.portThread != null && this.portThread.isAlive()) {
            try {
                this.portThread.join();
            }
            catch (Exception exception) {}
        }
        this.portThread = null;
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
        }
        if (this.stackUnits != null) {
            this.stackUnits.clear();
        }
        this.deviceModel = null;
    }

    static /* synthetic */ int access$0() {
        return 19;
    }

    static /* synthetic */ int access$1() {
        return 19;
    }

    static {
        Model_SysOID = new OID(".1.3.6.1.4.1.2.6.138");
        bundleName = "ibm.nways.jdm8239.Resources";
    }

    private class PortThread
    extends Thread {
        public void run() {
            JdmBrowser jdmBrowser;
            String string;
            String string2;
            GenModel genModel;
            String string3;
            String string4;
            String string5;
            String string6;
            GenModel genModel2;
            GenModel genModel3;
            GenModel genModel4;
            GenModel genModel5;
            ModelInfo modelInfo;
            block20: {
                if (RAS.isEnabled(StackInfo.access$0(), StackInfo.access$1())) {
                    RAS.enter(StackInfo.access$0(), StackInfo.access$1(), this, "run");
                }
                if (StackInfo.this.disposeCalled) {
                    return;
                }
                if (StackInfo.this.deviceBrowser != null && StackInfo.this.deviceBrowser.isNetscape()) {
                    PrivilegeManager.enablePrivilege((String)"UniversalConnect");
                }
                modelInfo = new ModelInfo();
                genModel5 = null;
                genModel4 = null;
                GenModel genModel6 = null;
                genModel3 = null;
                genModel2 = null;
                string6 = "ibm.nways.jdm8239.eui.TrPortPanel";
                string5 = "ibm.nways.jdm8239.eui.TrHubPanel";
                string4 = "ibm.nways.jdm8239.eui.TrRiRoPanel";
                string3 = "ibm.nways.jdm8239.eui.TrWrapPanel";
                genModel = StackInfo.this.getDeviceModel();
                StackInfo.this.getStackHubs();
                string2 = StackInfo.this.getBundleName();
                StackInfo.this.getPath();
                string = "ibm.nways.jdm8239.WCDefault";
                jdmBrowser = StackInfo.this.getDeviceBrowser();
                try {
                    genModel5 = (GenModel)genModel.getComponent("TrPort");
                    genModel4 = (GenModel)genModel.getComponent("PortMonitor");
                    genModel6 = (GenModel)genModel.getComponent("TrHub");
                    genModel3 = (GenModel)genModel.getComponent("TrRiRo");
                    genModel2 = (GenModel)genModel.getComponent("TrWrap");
                }
                catch (Exception exception) {
                    if (!RAS.isEnabled(StackInfo.access$0(), StackInfo.access$1())) break block20;
                    RAS.logException(StackInfo.access$0(), StackInfo.access$1(), this, "run", exception);
                }
            }
            int n = 0;
            while (n < 8) {
                block22: {
                    if (StackInfo.this.decoders[n] != null && StackInfo.this.decoders[n].module(STDecoder.HUBID) >= 0) {
                        WidgetCookie widgetCookie;
                        CookieTray cookieTray;
                        StackData stackData;
                        Integer n2;
                        block21: {
                            n2 = new Integer(StackInfo.this.decoders[n].module(STDecoder.HUBID));
                            stackData = (StackData)StackInfo.this.stackUnits.get(n2);
                            Integer n3 = stackData.hubPorts;
                            cookieTray = stackData.hubTray;
                            CookieTray cookieTray2 = stackData.portExtTray;
                            try {
                                int n4 = 1;
                                while (n4 <= n3) {
                                    modelInfo = new ModelInfo();
                                    modelInfo.add("Index.TrPortHubId", n2);
                                    modelInfo.add("Index.TrPortNumber", new Integer(n4));
                                    widgetCookie = new WidgetCookie("Port" + n4, string2, modelInfo, string, genModel4, jdmBrowser, 18);
                                    widgetCookie.SetAction(genModel5, modelInfo, string6);
                                    if (n4 > 16) {
                                        cookieTray2.AddWidget(widgetCookie);
                                    } else {
                                        cookieTray.AddWidget(widgetCookie);
                                    }
                                    ++n4;
                                }
                            }
                            catch (Exception exception) {
                                if (!RAS.isEnabled(StackInfo.access$0(), StackInfo.access$1())) break block21;
                                RAS.logException(StackInfo.access$0(), StackInfo.access$1(), this, "run", exception);
                            }
                        }
                        try {
                            modelInfo = new ModelInfo();
                            modelInfo.add("Index.TrHubId", n2);
                            if (stackData.riroTray != null) {
                                Integer n5 = stackData.riroType;
                                String string7 = null;
                                switch (n5) {
                                    case 1: {
                                        string7 = "Fiber";
                                        break;
                                    }
                                    case 2: {
                                        string7 = "Copper";
                                        break;
                                    }
                                }
                                widgetCookie = new WidgetCookie(String.valueOf(string7) + "RI", string2, modelInfo, string, (GenModel)genModel.getComponent("TrHubRiMonitor"), jdmBrowser, 16, string5);
                                widgetCookie.SetAction(genModel3, modelInfo, string4);
                                stackData.riroTray.AddWidget(widgetCookie);
                                widgetCookie = new WidgetCookie(String.valueOf(string7) + "RO", string2, modelInfo, string, (GenModel)genModel.getComponent("TrHubRoMonitor"), jdmBrowser, 16, string5);
                                widgetCookie.SetAction(genModel3, modelInfo, string4);
                                stackData.riroTray.AddWidget(widgetCookie);
                            }
                            widgetCookie = new WidgetCookie("ControlIn", string2, modelInfo, string, (GenModel)genModel.getComponent("TrHubDcInMonitor"), jdmBrowser, 16, string5);
                            widgetCookie.SetAction(genModel2, modelInfo, string3);
                            cookieTray.AddWidget(widgetCookie);
                            widgetCookie = new WidgetCookie("ControlOut", string2, modelInfo, string, (GenModel)genModel.getComponent("TrHubDcOutMonitor"), jdmBrowser, 16, string5);
                            widgetCookie.SetAction(genModel2, modelInfo, string3);
                            cookieTray.AddWidget(widgetCookie);
                            widgetCookie = new WidgetCookie("RstBtn", string2, null, string, null, jdmBrowser, 22);
                            cookieTray.AddWidget(widgetCookie);
                        }
                        catch (Exception exception) {
                            if (!RAS.isEnabled(StackInfo.access$0(), StackInfo.access$1())) break block22;
                            RAS.logException(StackInfo.access$0(), StackInfo.access$1(), this, "run", exception);
                        }
                    }
                }
                ++n;
            }
            if (RAS.isEnabled(StackInfo.access$0(), StackInfo.access$1())) {
                RAS.exit(StackInfo.access$0(), StackInfo.access$1(), this, "run");
            }
        }

        PortThread() {
            StackInfo.this = StackInfo.this;
        }
    }
}

